/*
 * meshifier test program
 *
 * Copyright 1995, 1996 Brad Grantham.  All Rights Reserved.
 *
 * Should compile in any ANSI C environment.
 */


#include <stdio.h>
#include <math.h>

#include "mesh.h"


#define DELTA .005

void testDrawEdge(meshVertex *v1, meshVertex *v2)
{
    printf("line %f %f %f %f %f %f 1 1 1\n",
        v1->v[X] + v1->n[X] * DELTA,
        v1->v[Y] + v1->n[Y] * DELTA,
        v1->v[Z] + v1->n[Z] * DELTA,
        v2->v[X] + v2->n[X] * DELTA,
        v2->v[Y] + v2->n[Y] * DELTA,
        v2->v[Z] + v2->n[Z] * DELTA);
}


meshVertex *tv1, *tv2, *tv3;

void testBeginStrip(meshVertex *v1, meshVertex *v2)
{
    static REAL r = .3, g = .3, b = .3;

    tv2 = v1;
    tv3 = v2;

    /* make a cyclic strip color.  Not guaranteed to make */
    /* unique for adjacent strips, but, hey, whatcha gonna do? */
    r += .3;
    if(r > 1.0){
	r = 0.3;
	g += .3;
	if(g > 1.0){
	    g = 0.3;
	    b += .3;
	    if(b > 1.0)
		b = .3;
	}
    }
    printf("objcolor %f %f %f\n", r, g, b);
}


/*
 * This cheezy function simply prints out a whole triangle, but a smart
 * implementation would really draw a triangle strip.  Sorry, I was in
 * a hurry and it proved the implementation.
 */
void testContStrip(meshVertex *v3)
{
    tv1 = tv2;
    tv2 = tv3;
    tv3 = v3;
    printf("trinorm");
    printf(" %f %f %f %f %f %f",
	tv1->v[X], tv1->v[Y], tv1->v[Z], tv1->n[X], tv1->n[Y], tv1->n[Z]);
    printf(" %f %f %f %f %f %f",
	tv2->v[X], tv2->v[Y], tv2->v[Z], tv2->n[X], tv2->n[Y], tv2->n[Z]);
    printf(" %f %f %f %f %f %f",
	tv3->v[X], tv3->v[Y], tv3->v[Z], tv3->n[X], tv3->n[Y], tv3->n[Z]);
    printf("\n");
}


void testDrawText(REAL v[3], char *text)
{
    printf("text %f %f %f 1 1 1 %s\n", v[X], v[Y], v[Z], text);
}


void testDrawLine(REAL v1[3], REAL v2[3])
{
    printf("line %f %f %f %f %f %f 1 1 1\n", v1[X], v1[Y], v1[Z],
        v2[X], v2[Y], v2[Z]);
}


void getInput(void)
{
    int i;

    int vertcnt;
    meshVec3 v, n, t;
    meshVec4 c;

    int tricnt;
    int v1, v2, v3;

    meshReset();

    scanf(" %d", &vertcnt);
    for(i = 0; i < vertcnt; i++){
        scanf(" %f %f %f", &v[X], &v[Y], &v[Z]);
        scanf(" %f %f %f", &n[X], &n[Y], &n[Z]);

#if HAVECOLORTEX

	/* 
	 * I don't have color or texture data sets but you might.
	 */

        scanf(" %f %f %f %f", &c[R], &c[G], &c[B], &c[A]);
        scanf(" %f %f %f", &n[X], &n[Y], &n[Z]);

#else

	/* boring gray color */
        c[R] = 0.75f;
        c[G] = 0.75f;
        c[B] = 0.75f;
        c[A] = 1.0f;

	/* no texture coordinate */
	t[R] = 0.0f;
	t[S] = 0.0f;
	t[T] = 0.0f;

#endif

        meshAddVertex(v, n, c, t);

    }

    scanf(" %d", &tricnt);
    for(i = 0; i < tricnt; i++){
        scanf(" %d %d %d", &v1, &v2, &v3);
	meshAddTriangle(v1, v2, v3);
    }
}


int main(int argc, char **argv)
{
    int meshCnt;

    if(argc > 1)
    {
        argv = argv; /* ! */
	fprintf(stderr, "%s: meshifier\n", argv[0]);
	fprintf(stderr, "accepts a vertex count and a list of vertex and "
	    "normal sextets, then\n");
	fprintf(stderr, "a triangle count and a list of triplets of indices "
	    "into the vertex list.\n");
	exit(1);
    }

    meshSetProcs(testDrawText, testDrawLine, testDrawEdge,
        testBeginStrip, testContStrip, NULL);

    getInput();

    meshSetFlag(MESH_DRAWSTRIPOUTLINES, TRUE);
    meshSetFlag(MESH_DRAWCONNECTIVITY, FALSE);
    
    meshCnt = meshCreateStrips();

    fprintf(stderr, "Total # of meshes: %d\n", meshCnt);

    return(0);
}
