/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URL;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OneRepMaxApplet
extends Applet
implements MouseListener,
MouseMotionListener,
KeyListener {
    static final int minWeight = 0;
    static final int minMaxWeight = 100;
    static final int minMaxReps = 5;
    static final int maxMinReps = 4;
    int eventVerbose;
    int nonEventVerbose;
    boolean doDoubleBuffer;
    Image backBufferImage;
    MyGraphics mostRecentGraphics;
    int prevX;
    int prevY;
    boolean button1IsDown;
    boolean button2IsDown;
    boolean button3IsDown;
    int minReps;
    int maxWeight;
    int maxReps;
    double majorGrayLevel;
    double medorGrayLevel;
    double minorGrayLevel;
    double pickReps;
    double pickWeight;
    boolean useSteeperCurve;
    boolean showRonsBizarreSamples;
    Image verticalAxisLabelImage;
    boolean psDumpRequested;
    boolean windowDumpRequested;

    private final String getParameterString(String paramName, String defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            return paramValueString;
        }
        return defaultValue;
    }

    private final int getParameterInt(String paramName, int defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                return Integer.decode(paramValueString);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return defaultValue;
    }

    private final double getParameterDouble(String paramName, double defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                return Double.parseDouble(paramValueString);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return defaultValue;
    }

    private final boolean getParameterBoolean(String paramName, boolean defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                int n = Integer.decode(paramValueString);
                boolean bl = false;
                if (n != 0) {
                    bl = true;
                }
                return bl;
            }
            catch (NumberFormatException e) {
                return paramValueString.equalsIgnoreCase("true") || paramValueString.equalsIgnoreCase("yes") || paramValueString.equalsIgnoreCase("t") || paramValueString.equalsIgnoreCase("y");
            }
        }
        return defaultValue;
    }

    public void init() {
        this.eventVerbose = this.getParameterInt("EventVerbose", this.eventVerbose);
        if (this.eventVerbose >= 1) {
            System.out.println("in init");
        }
        this.nonEventVerbose = this.getParameterInt("nonEventVerbose", this.nonEventVerbose);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        if (this.eventVerbose >= 1) {
            System.out.println("out init");
        }
    }

    public void start() {
        if (this.eventVerbose >= 1) {
            System.out.println("in start");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out start");
        }
    }

    public void stop() {
        if (this.eventVerbose >= 1) {
            System.out.println("in stop");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out stop");
        }
    }

    public void destroy() {
        if (this.eventVerbose >= 1) {
            System.out.println("in destroy");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out destroy");
        }
    }

    private static final int getButton(MouseEvent e) {
        int mods = e.getModifiers();
        if ((mods & 8) != 0) {
            return 2;
        }
        if ((mods & 4) != 0) {
            return 3;
        }
        return 1;
    }

    public void mousePressed(MouseEvent e) {
        int whichButton;
        if (this.eventVerbose >= 1) {
            System.out.println("in mousePressed: " + e);
        }
        if (this.eventVerbose >= 1) {
            if (OneRepMaxApplet.getButton(e) == 1) {
                System.out.println("    (left mouse)");
            }
            if (OneRepMaxApplet.getButton(e) == 2) {
                System.out.println("    (middle mouse)");
            }
            if (OneRepMaxApplet.getButton(e) == 3) {
                System.out.println("    (right mouse)");
            }
        }
        int thisX = e.getX();
        int thisY = e.getY();
        if (this.mostRecentGraphics != null) {
            double[] xy = new double[2];
            this.mostRecentGraphics.pick(thisX, thisY, xy);
            this.pickReps = xy[0];
            this.pickWeight = xy[1];
            this.repaint();
        }
        if ((whichButton = OneRepMaxApplet.getButton(e)) == 1) {
            this.button1IsDown = true;
        } else if (whichButton == 2) {
            this.button2IsDown = true;
        } else if (whichButton == 3) {
            this.button3IsDown = true;
        }
        this.prevX = thisX;
        this.prevY = thisY;
        if (this.eventVerbose >= 1) {
            System.out.println("out mousePressed: " + e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        int whichButton;
        if (this.eventVerbose >= 1) {
            System.out.println("in mouseReleased: " + e);
        }
        if ((whichButton = OneRepMaxApplet.getButton(e)) == 1) {
            this.button1IsDown = false;
        } else if (whichButton == 2) {
            this.button2IsDown = false;
        } else if (whichButton == 3) {
            this.button3IsDown = false;
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mouseReleased: " + e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in mouseEntered: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mouseEntered: " + e);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in mouseExited: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mouseExited: " + e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in mouseClicked: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mouseClicked: " + e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.eventVerbose >= 2) {
            System.out.println("  in mouseDragged: " + e);
        }
        int thisX = e.getX();
        int thisY = e.getY();
        if (this.mostRecentGraphics != null) {
            double[] xy = new double[2];
            this.mostRecentGraphics.pick(thisX, thisY, xy);
            this.pickReps = xy[0];
            this.pickWeight = xy[1];
            this.repaint();
        }
        this.prevX = thisX;
        this.prevY = thisY;
        if (this.eventVerbose >= 2) {
            System.out.println("  out mouseDragged: " + e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.eventVerbose >= 3) {
            System.out.println("    in mouseMoved: " + e);
        }
        if (this.eventVerbose >= 3) {
            System.out.println("    out mouseMoved: " + e);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in keyPressed: " + e);
        }
        switch (e.getKeyCode()) {
            case 38: {
                this.maxWeight += 50;
                this.repaint();
                break;
            }
            case 40: {
                this.maxWeight -= 50;
                this.maxWeight = this.maxWeight >= 100 ? this.maxWeight : 100;
                this.repaint();
                break;
            }
            case 37: {
                if (e.isControlDown()) {
                    --this.minReps;
                } else {
                    --this.maxReps;
                    this.maxReps = this.maxReps >= 5 ? this.maxReps : 5;
                }
                this.repaint();
                break;
            }
            case 39: {
                if (e.isControlDown()) {
                    ++this.minReps;
                    this.minReps = this.minReps <= 4 ? this.minReps : 4;
                } else {
                    ++this.maxReps;
                }
                this.repaint();
                break;
            }
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out keyPressed: " + e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in keyReleased: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out keyReleased: " + e);
        }
    }

    public void keyTyped(KeyEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in keyTyped: " + e);
        }
        switch (e.getKeyChar()) {
            case 'V': {
                System.out.print("eventVerbose " + this.eventVerbose);
                this.eventVerbose = (this.eventVerbose + 1) % 4;
                System.out.println(" -> " + this.eventVerbose);
                break;
            }
            case ' ': {
                this.repaint();
                break;
            }
            case 'B': {
                this.doDoubleBuffer ^= true;
                System.out.println("doDoubleBuffer -> " + this.doDoubleBuffer);
                this.repaint();
                break;
            }
            case 'a': {
                this.useSteeperCurve ^= true;
                System.out.println("useSteeperCurve -> " + this.useSteeperCurve);
                this.repaint();
                break;
            }
            case 'r': {
                this.showRonsBizarreSamples ^= true;
                System.out.println("showRonsBizarreSamples -> " + this.showRonsBizarreSamples);
                this.repaint();
                break;
            }
            default: {
                System.out.println("Unknown key '" + e.getKeyChar() + "'(" + e.getKeyChar() + ") typed");
                break;
            }
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out keyTyped: " + e);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    static double extrap(double x0, double y0, double x1, double y1, double x) {
        double t = (x - x0) / (x1 - x0);
        return y0 + t * (y1 - y0);
    }

    static double lerp(double a, double b, double t) {
        return a + t * (b - a);
    }

    public void paint(Graphics frontBufferGraphics) {
        String label;
        MyGraphics mg;
        if (this.eventVerbose >= 1) {
            System.out.println("in paint");
        }
        this.makeSureBackBufferIsRight();
        Graphics g = this.doDoubleBuffer ? this.backBufferImage.getGraphics() : frontBufferGraphics;
        Dimension size = this.getSize();
        double minSize = size.width <= size.height ? size.width : size.height;
        this.mostRecentGraphics = mg = new MyGraphics(g, size, (double)this.minReps - 1.2, this.maxReps + 1, -100.0, this.maxWeight + 100);
        mg.setColor(Color.black);
        mg.fillWindow();
        double[] yellow = new double[]{0.75, 0.75, 0.5};
        double[] green = new double[]{0.5, 1.0, 0.5};
        this.medorGrayLevel = this.medorGrayLevel >= this.minorGrayLevel ? this.medorGrayLevel : this.minorGrayLevel;
        this.majorGrayLevel = this.majorGrayLevel >= this.medorGrayLevel ? this.majorGrayLevel : this.medorGrayLevel;
        double[] color = green;
        Color minorGray = new Color((int)(this.minorGrayLevel * color[0] * 255.5), (int)(this.minorGrayLevel * color[1] * 255.5), (int)(this.minorGrayLevel * color[2] * 255.5));
        Color medorGray = new Color((int)(this.medorGrayLevel * color[0] * 255.5), (int)(this.medorGrayLevel * color[1] * 255.5), (int)(this.medorGrayLevel * color[2] * 255.5));
        Color majorGray = new Color((int)(this.majorGrayLevel * color[0] * 255.5), (int)(this.majorGrayLevel * color[1] * 255.5), (int)(this.majorGrayLevel * color[2] * 255.5));
        int weight = 0;
        while (weight <= this.maxWeight) {
            if (weight % 100 == 0) {
                mg.setColor(majorGray);
            } else if (weight % 10 == 0) {
                mg.setColor(medorGray);
            } else {
                mg.setColor(minorGray);
            }
            mg.drawLine(1.0, weight, this.maxReps, weight);
            weight += 5;
        }
        mg.setColor(majorGray);
        int reps = this.minReps;
        while (reps <= this.maxReps) {
            mg.drawLine(reps, 0.0, reps, this.maxWeight);
            ++reps;
        }
        mg.setColor(Color.white);
        mg.drawLine(this.minReps, 0.0, this.maxReps, 0.0);
        mg.drawLine(this.minReps, 0.0, this.minReps, this.maxWeight);
        mg.drawLine(this.maxReps, 0.0, this.maxReps, this.maxWeight);
        mg.drawLine(this.minReps, this.maxWeight, this.maxReps, this.maxWeight);
        mg.setColor(Color.yellow.darker());
        int weight2 = 0;
        while (weight2 <= this.maxWeight) {
            double weightAtMaxReps = OneRepMaxApplet.extrap(1.0, weight2, 10.0, 0.75 * (double)weight2, this.maxReps);
            if (this.useSteeperCurve) {
                weightAtMaxReps = OneRepMaxApplet.extrap(1.0, weight2, 8.0, 0.7777777777777778, this.maxReps);
            }
            double x10 = (double)this.maxReps + 0.1;
            double y10 = weightAtMaxReps;
            if (weight2 != 0) {
                label = ((weightAtMaxReps = (double)Math.round(weightAtMaxReps * 10.0) / 10.0) < 100.0 ? " " : "") + weightAtMaxReps;
                if (label.endsWith(".0")) {
                    label = label.substring(0, label.length() - 2);
                }
                mg.drawStringLeftJustified(label, x10, y10);
            }
            weight2 += 50;
        }
        mg.setColor(Color.white);
        weight2 = 0;
        while (weight2 <= this.maxWeight) {
            double x0 = (double)this.minReps - 0.1;
            double x1 = (double)this.maxReps + 0.1;
            double y = weight2;
            if (weight2 != 0) {
                label = (weight2 < 100 ? " " : "") + weight2;
                mg.drawStringRightJustified(label, x0, y);
                mg.drawStringLeftJustified(label, x1, y);
            }
            weight2 += 50;
        }
        mg.setColor(Color.white);
        int reps2 = this.minReps;
        while (reps2 <= this.maxReps) {
            double x = reps2;
            double y = -20.0;
            mg.drawStringCentered("" + reps2, x, y);
            ++reps2;
        }
        mg.setColor(Color.yellow.darker());
        int minRepMax = 0;
        while (minRepMax <= this.maxWeight) {
            if (minRepMax != 0) {
                double frac = (this.minReps - 1) / (this.maxReps - 1);
                double oneRepMax = (double)minRepMax / OneRepMaxApplet.lerp(1.0, 0.75, frac);
                double maxRepMax = OneRepMaxApplet.extrap(1.0, oneRepMax, 10.0, 0.75 * oneRepMax, this.maxReps);
                if (this.useSteeperCurve) {
                    maxRepMax = OneRepMaxApplet.extrap(1.0, oneRepMax, 8.0, 0.7777777777777778 * oneRepMax, this.maxReps);
                }
                mg.drawLine(this.minReps, minRepMax, this.maxReps, maxRepMax);
            }
            minRepMax += 50;
        }
        double pickRepsQuantized = Math.round(this.pickReps);
        double pickWeightQuantized = Math.round(this.pickWeight / (double)5) * (long)5;
        double fracOfOneRepMax = 0.75 + (10.0 - pickRepsQuantized) / 9.0 * 0.25;
        if (this.useSteeperCurve) {
            fracOfOneRepMax = 0.7777777777777778 + (8.0 - pickRepsQuantized) / 7.0 * 0.2222222222222222;
        }
        double pickOneRepMax = pickWeightQuantized / fracOfOneRepMax;
        double pickMaxRepMax = OneRepMaxApplet.extrap(1.0, pickOneRepMax, 10.0, 0.75 * pickOneRepMax, this.maxReps);
        double pickMinRepMax = OneRepMaxApplet.extrap(1.0, pickOneRepMax, 10.0, 0.75 * pickOneRepMax, this.minReps);
        if (this.useSteeperCurve) {
            pickMaxRepMax = OneRepMaxApplet.extrap(1.0, pickOneRepMax, 8.0, 0.7777777777777778 * pickOneRepMax, this.maxReps);
            pickMinRepMax = OneRepMaxApplet.extrap(1.0, pickOneRepMax, 8.0, 0.7777777777777778 * pickOneRepMax, this.minReps);
        }
        mg.setColor(Color.yellow);
        mg.drawLine(this.minReps, pickMinRepMax, this.maxReps, pickMaxRepMax);
        int reps3 = this.minReps;
        while (reps3 <= this.maxReps) {
            double weight3 = pickMinRepMax + (double)(reps3 - this.minReps) / (double)(this.maxReps - this.minReps) * (pickMaxRepMax - pickMinRepMax);
            weight3 = (double)Math.round(weight3 * 10.0) / 10.0;
            mg.drawPoint(reps3, weight3, 5);
            String label2 = "" + weight3;
            if (label2.endsWith(".0")) {
                label2 = label2.substring(0, label2.length() - 2);
            }
            if (reps3 - this.minReps < this.maxReps - reps3) {
                mg.drawString(label2, reps3, weight3, -1.0, 1.1);
            } else {
                mg.drawString(label2, reps3, weight3, 1.0, -0.9);
            }
            ++reps3;
        }
        mg.drawPoint(pickRepsQuantized, pickWeightQuantized, 7);
        if (this.showRonsBizarreSamples) {
            int[][][] RonsBizarreSamples = new int[][][]{new int[][]{{300, 1}, {250, 5}, {225, 8}}, new int[][]{{400, 1}, {340, 5}}, new int[][]{{405, 1}, {345, 5}, {335, 6}, {325, 7}, {315, 8}}, new int[][]{{500, 1}, {430, 5}, {405, 8}}, new int[][]{{555, 1}, {475, 5}, {405, 16}, {315, 31}, {225, 61}, {135, 100}}};
            mg.setColor(Color.white);
            int iCurve = 0;
            while (iCurve < RonsBizarreSamples.length) {
                int[][] curve = RonsBizarreSamples[iCurve];
                int iSeg = 0;
                while (iSeg < curve.length) {
                    mg.drawPoint(curve[iSeg][1], curve[iSeg][0], 7);
                    if (iSeg > 0) {
                        mg.drawLine(curve[iSeg - 1][1], curve[iSeg - 1][0], curve[iSeg][1], curve[iSeg][0]);
                    }
                    ++iSeg;
                }
                ++iCurve;
            }
        }
        mg.setColor(Color.white);
        mg.drawString("Reps", (double)(this.minReps + this.maxReps) / (double)2, -20.0 - mg.getFontHeight(), 0.0, -1.0);
        if (this.verticalAxisLabelImage == null) {
            this.verticalAxisLabelImage = OneRepMaxApplet.makeVerticalStringImage("Weight", Color.black, Color.white, g, this);
        }
        if (this.verticalAxisLabelImage != null) {
            double[] xy = new double[2];
            mg.unpick((double)this.minReps - 0.1, (double)this.maxWeight / (double)2, xy);
            double x = xy[0] - (double)g.getFontMetrics().stringWidth("1000") - (double)this.verticalAxisLabelImage.getWidth(null) - (double)5;
            double y = xy[1] - 0.5 * (double)this.verticalAxisLabelImage.getHeight(null);
            g.drawImage(this.verticalAxisLabelImage, (int)Math.round(x), (int)Math.round(y), this);
        }
        if (g != frontBufferGraphics) {
            frontBufferGraphics.drawImage(this.backBufferImage, 0, 0, this);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out paint");
        }
    }

    private final void makeSureBackBufferIsRight() {
        if (this.doDoubleBuffer) {
            Dimension size = this.getSize();
            if (this.backBufferImage == null || this.backBufferImage.getWidth(this) != size.width || this.backBufferImage.getHeight(this) != size.height) {
                if (this.eventVerbose >= 1) {
                    System.out.println("Creating back buffer " + size.width + 'x' + size.height);
                }
                this.backBufferImage = this.createImage(size.width, size.height);
            }
        } else {
            this.backBufferImage = null;
        }
    }

    private static final Image makeVerticalStringImage(String labelString, Color bgColor, Color fgColor, Graphics g, Component component) {
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth(labelString);
        int height = fm.getHeight() - fm.getLeading();
        Image image0 = component.createImage(width, height);
        Graphics ig = image0.getGraphics();
        ig.setColor(bgColor);
        ig.fillRect(0, 0, width, height);
        ig.setFont(g.getFont());
        ig.setColor(fgColor);
        ig.drawString(labelString, 0, fm.getMaxAscent());
        int[] buf0 = new int[width * height];
        int[] buf = new int[height * width];
        PixelGrabber pixelGrabber = new PixelGrabber(image0, 0, 0, width, height, buf0, 0, width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                buf[i * height + j] = buf0[j * width + (width - 1 - i)];
                ++j;
            }
            ++i;
        }
        return component.createImage(new MemoryImageSource(height, width, buf, 0, height));
    }

    private static final boolean is_all_even(int[] array) {
        int i = 0;
        while (i < array.length) {
            if ((array[i] & 1) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(final String[] args) {
        System.out.println("in main");
        final Frame frame = new Frame("OneRepMax Applet"){

            public final boolean handleEvent(Event event) {
                if (event.id == 201) {
                    System.out.println("bye!");
                    this.dispose();
                    System.exit(0);
                    return true;
                }
                return super.handleEvent(event);
            }
        };
        frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent we) {
                System.out.println("ciao!");
                frame.dispose();
                System.exit(0);
            }
        });
        OneRepMaxApplet applet = new OneRepMaxApplet();
        applet.setStub(new AppletStub(){

            public final void appletResize(int width, int height) {
            }

            public final AppletContext getAppletContext() {
                return null;
            }

            public final URL getCodeBase() {
                return null;
            }

            public final URL getDocumentBase() {
                return null;
            }

            public final String getParameter(String name) {
                String prefix = name + '=';
                int i = 0;
                while (i < args.length) {
                    if (this.startsWithIgnoreCase(args[i], prefix)) {
                        return args[i].substring(prefix.length());
                    }
                    ++i;
                }
                return null;
            }

            public final boolean isActive() {
                return true;
            }

            private final boolean startsWithIgnoreCase(String s, String prefixMaybe) {
                return s.regionMatches(true, 0, prefixMaybe, 0, prefixMaybe.length());
            }
        });
        frame.add(applet);
        applet.init();
        applet.start();
        int size = applet.getParameterInt("size", -1);
        int width = applet.getParameterInt("width", size > 0 ? size : 800);
        int height = applet.getParameterInt("height", size > 0 ? size : 900);
        frame.move(400, 20);
        frame.resize(width, height);
        frame.show();
        System.out.println("out main");
    }

    private final /* synthetic */ void this() {
        this.eventVerbose = 0;
        this.nonEventVerbose = 0;
        this.doDoubleBuffer = true;
        this.backBufferImage = null;
        this.mostRecentGraphics = null;
        this.prevX = 0;
        this.prevY = 0;
        this.button1IsDown = false;
        this.button2IsDown = false;
        this.button3IsDown = false;
        this.minReps = 1;
        this.maxWeight = 500;
        this.maxReps = 10;
        this.majorGrayLevel = 0.85;
        this.medorGrayLevel = 0.65;
        this.minorGrayLevel = 0.45;
        this.pickReps = 1.0;
        this.pickWeight = 350.0;
        this.useSteeperCurve = false;
        this.showRonsBizarreSamples = false;
        this.verticalAxisLabelImage = null;
        this.psDumpRequested = false;
        this.windowDumpRequested = false;
    }

    public OneRepMaxApplet() {
        this.this();
    }
}

